/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.utils;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.utils.Frame;
import com.cubaix.TDenlive.utils.ImageUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Vector;

public class Frames {
    TDenlive tde = null;
    String frameDir = "frames";
    static final Vector<Frame> frames = new Vector();
    int thumbH = 45;

    public Frames(TDenlive aTDe) {
        this.tde = aTDe;
        this.thumbH = this.tde.config.thumbH;
    }

    public Frame getFrame(String aPath) {
        for (Frame aF : this.listFrames()) {
            if (!aF.path.equals(aPath)) continue;
            return aF;
        }
        return null;
    }

    public int getFrameIndex(String aPath) {
        int aI = 0;
        for (Frame aF : this.listFrames()) {
            if (aF.path.equals(aPath)) {
                return aI;
            }
            ++aI;
        }
        return -1;
    }

    public Vector<Frame> listFrames() {
        if (frames.size() > 0) {
            return frames;
        }
        Frame aF = new Frame("BLANK");
        aF.bi = ImageUtils.createImage(1920, 1080);
        Graphics aG = aF.bi.getGraphics();
        aG.setColor(Color.WHITE);
        aG.fillRect(0, 0, 1920, 1080);
        double aRatio = (double)aF.bi.getWidth() / (double)aF.bi.getHeight();
        BufferedImage aTb = ImageUtils.createImage((int)((double)this.thumbH * aRatio), this.thumbH);
        aTb.getGraphics().drawImage(aF.bi, 0, 0, (int)((double)this.thumbH * aRatio), this.thumbH, 0, 0, aF.bi.getWidth(), aF.bi.getHeight(), null);
        aF.thumbSwt = ImageUtils.imageToSwt(this.tde.gui.display, aTb);
        frames.add(aF);
        String aDir = Frames.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (aDir.toLowerCase().matches(".*[.](jar|exe)")) {
            aDir = new File(aDir).getParent();
        }
        aDir = URLDecoder.decode(aDir);
        System.out.println("Root: " + aDir);
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.frameDir).exists()) {
            aDir = new File(aDir).getParent();
            System.out.println("FrameSearch: " + aDir);
        }
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.frameDir).exists()) {
            aDir = String.valueOf(aDir) + File.separator + "distrib";
            System.out.println("FrameSearch: " + aDir);
        }
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.frameDir).exists()) {
            System.out.println("FrameSearch: NOT FOUND");
            return frames;
        }
        this.frameDir = String.valueOf(aDir) + File.separatorChar + this.frameDir;
        System.out.println("FrameDir: " + this.frameDir);
        this.listFrames(this.frameDir);
        return frames;
    }

    void listFrames(String aDir) {
        Object[] aFs = new File(aDir).listFiles();
        Arrays.sort(aFs);
        Object[] objectArray = aFs;
        int n = aFs.length;
        int n2 = 0;
        while (n2 < n) {
            Object aF = objectArray[n2];
            if (((File)aF).isDirectory()) {
                this.listFrames(((File)aF).getPath());
            }
            if (((File)aF).getName().toLowerCase().matches(".*[.](png|pgm|bmp|jpg|jpeg)")) {
                String aPath = ((File)aF).getPath();
                aPath = aPath.substring(aPath.indexOf(String.valueOf(this.frameDir) + File.separatorChar) + this.frameDir.length() + 1);
                aPath = aPath.replaceAll("[\\\\\\\\]", "/");
                Frame aFrame = new Frame(aPath);
                try {
                    aFrame.bi = ImageUtils.loadImage(((File)aF).getPath());
                    double aRatio = (double)aFrame.bi.getWidth() / (double)aFrame.bi.getHeight();
                    BufferedImage aTb = ImageUtils.createImage((int)((double)this.thumbH * aRatio), this.thumbH);
                    ImageUtils.chessBck(aTb);
                    aTb.getGraphics().drawImage(aFrame.bi, 0, 0, (int)((double)this.thumbH * aRatio), this.thumbH, 0, 0, aFrame.bi.getWidth(), aFrame.bi.getHeight(), null);
                    aFrame.thumbSwt = ImageUtils.imageToSwt(this.tde.gui.display, aTb);
                    frames.add(aFrame);
                    System.out.println("Frame: " + aPath);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        try {
            new Frames(null).listFrames();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

