/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.utils;

import com.cubaix.TDenlive.utils.PGMIO;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    public static final BufferedImage loadImage(String aPath) throws Exception {
        if (aPath.toLowerCase().endsWith(".pgm")) {
            return PGMIO.read(aPath);
        }
        return ImageIO.read(new File(aPath));
    }

    public static final void saveImage(String aPath, BufferedImage aBI) throws Exception {
        ImageIO.write((RenderedImage)aBI, "png", new File(aPath));
    }

    public static final BufferedImage createImage(int aWidth, int aHeight, boolean aHdr) {
        if (aHdr) {
            return ImageUtils.createHdr(aWidth, aHeight);
        }
        return ImageUtils.createImage(aWidth, aHeight);
    }

    public static final BufferedImage createImage(int aWidth, int aHeight) {
        BufferedImage aBI = new BufferedImage(aWidth, aHeight, 2);
        int[] aDBI = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int p = 0;
        while (p < aDBI.length) {
            aDBI[p] = 0;
            ++p;
        }
        return aBI;
    }

    public static final BufferedImage createHdr(int aWidth, int aHeight) {
        int bands = 4;
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] bandOffsets = nArray;
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(4, aWidth, aHeight, bands, aWidth * bands, bandOffsets);
        DataBufferFloat buffer = new DataBufferFloat(aWidth * aHeight * bands);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, buffer, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, true, false, 3, 4);
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    public static final BufferedImage toRes(BufferedImage aBI, int aH, boolean aHdr, boolean aFastMode, boolean aAddChess) {
        double aZoom = (double)aH / (double)aBI.getHeight();
        int aWidth = (int)((double)aBI.getWidth() * aZoom);
        int aHeight = aH;
        BufferedImage aHdrBI = ImageUtils.createImage(aWidth, aHeight, aHdr);
        Graphics2D g2 = (Graphics2D)aHdrBI.getGraphics();
        if (!aFastMode) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        if (aAddChess) {
            ImageUtils.chessBck(aHdrBI);
        }
        g2.drawImage(aBI, 0, 0, aWidth, aHeight, null);
        g2.dispose();
        return aHdrBI;
    }

    public static final void chessBck(BufferedImage aBI) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        Graphics2D g2 = (Graphics2D)aBI.getGraphics();
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, aWidth, aHeight);
        g2.setColor(Color.GRAY);
        int x = 0;
        while (x <= aWidth) {
            int y = 0;
            while (y <= aHeight) {
                if ((x + y) % 2 != 0) {
                    g2.fillRect(x, y, 5, 5);
                }
                y += 5;
            }
            x += 5;
        }
        g2.dispose();
    }

    public static final Image imageToSwt(Display aDisplay, BufferedImage aBI, boolean aHdr) {
        if (aHdr) {
            return ImageUtils.hdrToSwt(aDisplay, aBI);
        }
        return ImageUtils.imageToSwt(aDisplay, aBI);
    }

    public static final Image imageToSwt(Display aDisplay, BufferedImage aBI) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        ImageData aID = new ImageData(aWidth, aHeight, 32, new PaletteData(0xFF0000, 65280, 255));
        int[] aDBF = ((DataBufferInt)aBI.getRaster().getDataBuffer()).getData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                int aARGB = aDBF[y * aWidth + x];
                int aR = aARGB >> 16 & 0xFF;
                int aG = aARGB >> 8 & 0xFF;
                int aB = aARGB & 0xFF;
                int aA = aARGB >> 24 & 0xFF;
                int aPix = (aA & 0xFF) << 24 | (aR & 0xFF) << 16 | (aG & 0xFF) << 8 | aB & 0xFF;
                aID.setPixel(x, y, aPix);
                ++y;
            }
            ++x;
        }
        return new Image((Device)aDisplay, aID);
    }

    public static final Image hdrToSwt(Display aDisplay, BufferedImage aBI) {
        int aWidth = aBI.getWidth();
        int aHeight = aBI.getHeight();
        ImageData aID = new ImageData(aWidth, aHeight, 32, new PaletteData(0xFF0000, 65280, 255));
        float[][] aDBF = ((DataBufferFloat)aBI.getRaster().getDataBuffer()).getBankData();
        int x = 0;
        while (x < aWidth) {
            int y = 0;
            while (y < aHeight) {
                float aR = aDBF[0][y * aWidth * 4 + x * 4];
                float aG = aDBF[0][y * aWidth * 4 + x * 4 + 1];
                float aB = aDBF[0][y * aWidth * 4 + x * 4 + 2];
                float aA = aDBF[0][y * aWidth * 4 + x * 4 + 3];
                int aPix = ((int)(aA * 255.0f) & 0xFF) << 24 | ((int)(aR * 255.0f) & 0xFF) << 16 | ((int)(aG * 255.0f) & 0xFF) << 8 | (int)(aB * 255.0f) & 0xFF;
                aID.setPixel(x, y, aPix);
                ++y;
            }
            ++x;
        }
        return new Image((Device)aDisplay, aID);
    }
}

