/*
 * Decompiled with CFR 0.152.
 */
package com.cubaix.TDenlive.utils;

import com.cubaix.TDenlive.TDenlive;
import com.cubaix.TDenlive.utils.ImageUtils;
import com.cubaix.TDenlive.utils.Luma;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Vector;

public class Lumas {
    TDenlive tde = null;
    String lumaDir = "lumas";
    static final Vector<Luma> lumas = new Vector();
    int thumbH = 45;

    public Lumas(TDenlive aTDe) {
        this.tde = aTDe;
        this.thumbH = this.tde.config.thumbH;
    }

    public Luma getLuma(String aPath) {
        for (Luma aL : this.listLumas()) {
            if (!aL.path.equals(aPath)) continue;
            return aL;
        }
        return null;
    }

    public int getLumaIndex(String aPath) {
        int aI = 0;
        for (Luma aL : this.listLumas()) {
            if (aL.path.equals(aPath)) {
                return aI;
            }
            ++aI;
        }
        return -1;
    }

    public Vector<Luma> listLumas() {
        if (lumas.size() > 0) {
            return lumas;
        }
        Luma aL = new Luma("BLANK");
        aL.bi = ImageUtils.createImage(1920, 1080);
        Graphics aG = aL.bi.getGraphics();
        aG.setColor(Color.WHITE);
        aG.fillRect(0, 0, 1920, 1080);
        double aRatio = (double)aL.bi.getWidth() / (double)aL.bi.getHeight();
        BufferedImage aTb = ImageUtils.createImage((int)((double)this.thumbH * aRatio), this.thumbH);
        aTb.getGraphics().drawImage(aL.bi, 0, 0, (int)((double)this.thumbH * aRatio), this.thumbH, 0, 0, aL.bi.getWidth(), aL.bi.getHeight(), null);
        aL.thumbSwt = ImageUtils.imageToSwt(this.tde.gui.display, aTb);
        lumas.add(aL);
        String aDir = Lumas.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (aDir.toLowerCase().matches(".*[.](jar|exe)")) {
            aDir = new File(aDir).getParent();
        }
        aDir = URLDecoder.decode(aDir);
        System.out.println("Root: " + aDir);
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.lumaDir).exists()) {
            aDir = new File(aDir).getParent();
            System.out.println("LumaSearch: " + aDir);
        }
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.lumaDir).exists()) {
            aDir = String.valueOf(aDir) + File.separator + "distrib";
            System.out.println("LumaSearch: " + aDir);
        }
        if (!new File(String.valueOf(aDir) + File.separatorChar + this.lumaDir).exists()) {
            System.out.println("LumaSearch: NOT FOUND");
            return lumas;
        }
        this.lumaDir = String.valueOf(aDir) + File.separatorChar + this.lumaDir;
        System.out.println("LumaDir: " + this.lumaDir);
        this.listLumas(this.lumaDir);
        return lumas;
    }

    void listLumas(String aDir) {
        Object[] aFs = new File(aDir).listFiles();
        Arrays.sort(aFs);
        Object[] objectArray = aFs;
        int n = aFs.length;
        int n2 = 0;
        while (n2 < n) {
            Object aF = objectArray[n2];
            if (((File)aF).isDirectory()) {
                this.listLumas(((File)aF).getPath());
            }
            if (((File)aF).getName().toLowerCase().matches(".*[.](png|pgm|bmp|jpg|jpeg)")) {
                String aPath = ((File)aF).getPath();
                aPath = aPath.substring(aPath.indexOf(String.valueOf(this.lumaDir) + File.separatorChar) + this.lumaDir.length() + 1);
                aPath = aPath.replaceAll("[\\\\\\\\]", "/");
                Luma aL = new Luma(aPath);
                try {
                    aL.bi = ImageUtils.loadImage(((File)aF).getPath());
                    double aRatio = (double)aL.bi.getWidth() / (double)aL.bi.getHeight();
                    BufferedImage aTb = ImageUtils.createImage((int)((double)this.thumbH * aRatio), this.thumbH);
                    aTb.getGraphics().drawImage(aL.bi, 0, 0, (int)((double)this.thumbH * aRatio), this.thumbH, 0, 0, aL.bi.getWidth(), aL.bi.getHeight(), null);
                    aL.thumbSwt = ImageUtils.imageToSwt(this.tde.gui.display, aTb);
                    lumas.add(aL);
                    System.out.println("Luma: " + aPath);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        try {
            new Lumas(null).listLumas();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

