/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    long labelHandle;
    long imageHandle;
    long buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;
    String toolTipText;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return GTK.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return GTK.gtk_tree_view_column_get_width(this.handle);
    }

    @Override
    long gtk_clicked(long widget) {
        if (GTK.GTK4) {
            this.sendSelectionEvent(13);
            return 0L;
        }
        boolean doubleClick = false;
        boolean postEvent = true;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int[] eventButton = new int[1];
            if (GTK.GTK4) {
                eventButton[0] = GDK.gdk_button_event_get_button(eventPtr);
            } else {
                GDK.gdk_event_get_button(eventPtr, eventButton);
            }
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Control.fixGdkEventTypeValues(eventType);
            int eventTime = GDK.gdk_event_get_time(eventPtr);
            switch (eventType) {
                case 7: {
                    int clickTime = this.display.getDoubleClickTime();
                    if (this.lastButton == eventButton[0] && this.lastTime != 0 && Math.abs(this.lastTime - eventTime) <= clickTime) {
                        doubleClick = true;
                    }
                    this.lastTime = eventTime == 0 ? 1 : eventTime;
                    this.lastButton = eventButton[0];
                    break;
                }
            }
            this.gdk_event_free(eventPtr);
        }
        if (postEvent) {
            this.sendSelectionEvent(doubleClick ? 14 : 13);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: {
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                if (eventButton[0] != 3) break;
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(gdkEvent, eventRX, eventRY);
                this.parent.showMenu((int)eventRX[0], (int)eventRY[0]);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        this.useFixedWidth = false;
        GtkAllocation widgetAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, widgetAllocation);
        boolean minimumResizeSignal = widgetAllocation.width == 1 && widgetAllocation.height == 1;
        boolean movingSignal = widgetAllocation.x == 0 && widgetAllocation.y == 0;
        int x = widgetAllocation.x;
        int width = widgetAllocation.width;
        if (x != this.lastX && !movingSignal) {
            this.lastX = x;
            this.sendEvent(10);
        }
        if (width != this.lastWidth && !minimumResizeSignal) {
            this.lastWidth = width;
            this.sendEvent(11);
        }
        GTK.gtk_widget_set_can_focus(this.buttonHandle, false);
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.buttonHandle != 0L) {
            if (GTK.GTK4) {
                long eventController = GTK.gtk_event_controller_legacy_new();
                OS.g_signal_connect_closure(eventController, OS.event, this.display.getClosure(15), false);
                GTK.gtk_widget_add_controller(this.buttonHandle, eventController);
            } else {
                OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
                OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
        }
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        if (this.buttonHandle != 0L) {
            boolean hideHeader = !GTK.gtk_widget_get_visible(this.buttonHandle);
            GtkRequisition requisition = new GtkRequisition();
            GTK.gtk_widget_show(this.buttonHandle);
            this.gtk_widget_get_preferred_size(this.buttonHandle, requisition);
            if (hideHeader) {
                GTK.gtk_widget_hide(this.buttonHandle);
            }
            width = requisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            boolean calcWidth = false;
            Rectangle itemBounds = null;
            int tableHeight = 0;
            if (this.parent.isVisible()) {
                Rectangle tableBounds = this.parent.getBounds();
                tableHeight = tableBounds.height - this.parent.getHeaderHeight();
            } else {
                calcWidth = true;
            }
            for (int i = 0; i < this.parent.items.length; ++i) {
                TableItem item = this.parent.items[i];
                if (itemBounds == null && item != null) {
                    itemBounds = item.getBounds();
                }
                boolean isVisible = false;
                if (!calcWidth && itemBounds != null) {
                    int itemTopBound = itemBounds.y + itemBounds.height * i + i;
                    int itemBottomBound = itemTopBound + itemBounds.height;
                    boolean bl = isVisible = itemTopBound > 0 && itemBottomBound < tableHeight;
                }
                if (item == null || !item.cached || !isVisible && !calcWidth) continue;
                width = Math.max(width, this.parent.calculateWidth(this.handle, item.handle));
            }
        } else {
            long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.parent.modelHandle, iter)) {
                do {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, iter));
                } while (GTK.gtk_tree_model_iter_next(this.parent.modelHandle, iter));
            }
            OS.g_free(iter);
        }
        this.setWidthInPixels(width);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.buttonHandle = 0L;
        this.handle = 0L;
        this.modelIndex = -1;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, index == 0, this.style);
    }

    void setFontDescription(long font) {
        this.setFontDescription(this.labelHandle, font);
        this.setFontDescription(this.imageHandle, font);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList headerImageList = this.parent.headerImageList;
            if (headerImageList == null) {
                headerImageList = this.parent.headerImageList = new ImageList();
            }
            if ((imageIndex = headerImageList.indexOf(image)) == -1) {
                imageIndex = headerImageList.add(image);
            }
            GTK.gtk_image_set_from_pixbuf(this.imageHandle, headerImageList.getPixbuf(imageIndex));
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK.gtk_image_clear(this.imageHandle);
            } else {
                GTK.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_resizable(this.handle, resizable);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_reorderable(this.handle, moveable);
    }

    @Override
    void setOrientation(boolean create) {
        if (!((this.parent.style & 0x4000000) == 0 && create || this.buttonHandle == 0L)) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.buttonHandle, dir);
            GTK.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, dir);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        } else {
            GTK.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        this.setToolTipText(shell, string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        shell.setToolTipText(this.buttonHandle, newString);
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(width));
    }

    void setWidthInPixels(int width) {
        long windowList;
        long window;
        this.checkWidget();
        if (width < 0) {
            return;
        }
        if (width == this.lastWidth) {
            return;
        }
        if (width > 0) {
            this.useFixedWidth = true;
            GTK.gtk_tree_view_column_set_fixed_width(this.handle, width);
        }
        if (width != 0) {
            GTK.gtk_widget_realize(this.parent.handle);
        }
        GTK.gtk_tree_view_column_set_visible(this.handle, width != 0);
        this.lastWidth = width;
        if (width != 0 && this.buttonHandle != 0L && !GTK.GTK4 && (window = GTK.gtk_widget_get_parent_window(this.buttonHandle)) != 0L && (windowList = GDK.gdk_window_get_children(window)) != 0L) {
            long windows = windowList;
            long[] userData = new long[1];
            while (windows != 0L) {
                long child = OS.g_list_data(windows);
                GDK.gdk_window_get_user_data(child, userData);
                if (userData[0] == this.buttonHandle) {
                    GDK.gdk_window_lower(child);
                    break;
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
        this.sendEvent(11);
    }

    @Override
    long dpiChanged(long object, long arg0) {
        super.dpiChanged(object, arg0);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

